<?php

use App\Model\Admin_url;
use Illuminate\Database\Seeder;

class Admin_url_Seeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $admin_url_data = [
            [
            'id'=>1,
            'section'=>'report',
            'heading'=>'payment',
            'details'    => json_encode([
                    [
                        'id'=>1,
                        'need_permission'=>true,
                        'name'=>'order_payment.index',
                        'heading'=>'Index',
                        'url'=>'admin/reports/payments',
                    ],
                    [
                        'id'=>2,
                        'need_permission'=>false,
                        'name'=>'payment.index',
                        'heading'=>'Search',
                        'url'=>'admin/reports/payments',
                    ],
                    [
                        'id'=>3,
                        'need_permission'=>true,
                        'name'=>'payment.payment_refund',
                        'type'=>'json',
                        'heading'=>'Refund',
                        'url'=>'payment/payment_refund/{id}',
                    ]
                ])

            ],
            [
                'id'=>2,
                'section'=>'report',
                'heading'=>'permissions',
                'details'    => json_encode([
                    [
                        'id'=>1,
                        'need_permission'=>true,
                        'name'=>'permissions.index',
                        'heading'=>'Index',
                        'url'=>'permissions',
                    ],
                ])

            ],
            [
                'id'=>3,
                'section'=>'module',
                'heading'=>'Courses',
                'details'    => json_encode([
                    [
                        'id'=>1,
                        'need_permission'=>true,
                        'name'=>'courses.index',
                        'heading'=>'Index',
                        'url'=>'admin/courses',
                    ],
                    [
                        'id'=>2,
                        'need_permission'=>'courses.index',
                        'name'=>'get_courses.index',
                        'heading'=>'Index',
                        'url'=>'admin/courses/get_courses',
                    ],
                    [
                        'id'=>3,
                        'need_permission'=>false,
                        'name'=>'courses.create',
                        'heading'=>'Create',
                        'url'=>'admin/courses/create',
                    ],
                    [
                        'id'=>4,
                        'need_permission'=>true,
                        'name'=>'courses.save',
                        'heading'=>'Save',
                        'url'=>'admin/courses/save',
                    ],
                    [
                        'id'=>5,
                        'need_permission'=>false,
                        'name'=>'courses.edit',
                        'heading'=>'Edit',
                        'url'=>'admin/courses/edit/{id}',
                    ],
                    [
                        'id'=>6,
                        'need_permission'=>true,
                        'name'=>'courses.update',
                        'heading'=>'Update',
                        'url'=>'admin/courses/update/{id}',
                    ],
                    [
                        'id'=>7,
                        'need_permission'=>true,
                        'name'=>'courses.delete',
                        'heading'=>'Delete',
                        'url'=>'admin/courses/delete/{id}',
                    ],
                ])

                ],
                [
                    'id'=>4,
                    'section'=>'module',
                    'heading'=>'Category',
                    'details'    => json_encode([
                        [
                            'id'=>1,
                            'need_permission'=>true,
                            'name'=>'category.index',
                            'heading'=>'Index',
                            'url'=>'admin/category',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>'category.index',
                            'name'=>'get_category.index',
                            'heading'=>'Index',
                            'url'=>'admin/category/get_category',
                        ],
                        [
                            'id'=>3,
                            'need_permission'=>false,
                            'name'=>'category.create',
                            'heading'=>'Create',
                            'url'=>'admin/category/create',
                        ],
                        [
                            'id'=>4,
                            'need_permission'=>true,
                            'name'=>'category.save',
                            'heading'=>'Save',
                            'url'=>'admin/category/save',
                        ],
                        [
                            'id'=>5,
                            'need_permission'=>false,
                            'name'=>'category.edit',
                            'heading'=>'Edit',
                            'url'=>'admin/category/edit/{id}',
                        ],
                        [
                            'id'=>6,
                            'need_permission'=>true,
                            'name'=>'category.update',
                            'heading'=>'Update',
                            'url'=>'admin/category/update/{id}',
                        ],
                        [
                            'id'=>7,
                            'need_permission'=>true,
                            'name'=>'category.delete',
                            'heading'=>'Delete',
                            'url'=>'admin/category/delete/{id}',
                        ],
                    ])

                    ],
                [
                    'id'=>5,
                    'section'=>'module',
                    'heading'=>'aboutus',
                    'details'    => json_encode([
                        [
                            'id'=>1,
                            'need_permission'=>false,
                            'name'=>'aboutus.index',
                            'heading'=>'Index',
                            'url'=>'admin/aboutus',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>false,
                            'name'=>'aboutus.create',
                            'heading'=>'Create',
                            'url'=>'admin/aboutus/create',
                        ],
                        [
                            'id'=>3,
                            'need_permission'=>false,
                            'name'=>'aboutus.save',
                            'heading'=>'Save',
                            'url'=>'admin/aboutus/save',
                        ],
                        [
                            'id'=>4,
                            'need_permission'=>false,
                            'name'=>'aboutus.edit',
                            'heading'=>'Edit',
                            'url'=>'admin/aboutus/edit/{id}',
                        ],
                        [
                            'id'=>5,
                            'need_permission'=>true,
                            'name'=>'aboutus.update',
                            'heading'=>'Update',
                            'url'=>'admin/aboutus/update/{id}',
                        ],
                        [
                            'id'=>6,
                            'need_permission'=>true,
                            'name'=>'aboutus.delete',
                            'heading'=>'Delete',
                            'url'=>'admin/aboutus/delete/{id}',
                        ],
                    ])

                    ],
                [
                    'id'=>6,
                    'section'=>'module',
                    'heading'=>'books',
                    'details'    => json_encode([
                        [
                            'id'=>1,
                            'need_permission'=>true,
                            'name'=>'books.index',
                            'heading'=>'Index',
                            'url'=>'admin/books',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>'books.index',
                            'name'=>'get_books.index',
                            'heading'=>'Index',
                            'url'=>'admin/books/get_books',
                        ],
                        [
                            'id'=>3,
                            'need_permission'=>false,
                            'name'=>'books.create',
                            'heading'=>'Create',
                            'url'=>'admin/books/create',
                        ],
                        [
                            'id'=>4,
                            'need_permission'=>true,
                            'name'=>'books.save',
                            'heading'=>'Save',
                            'url'=>'admin/books/save',
                        ],
                        [
                            'id'=>5,
                            'need_permission'=>false,
                            'name'=>'books.edit',
                            'heading'=>'Edit',
                            'url'=>'admin/books/edit/{id}',
                        ],
                        [
                            'id'=>6,
                            'need_permission'=>true,
                            'name'=>'books.update',
                            'heading'=>'Update',
                            'url'=>'admin/books/update/{id}',
                        ],
                        [
                            'id'=>7,
                            'need_permission'=>true,
                            'name'=>'books.delete',
                            'heading'=>'Delete',
                            'url'=>'admin/books/delete/{id}',
                        ],
                    ])

                    ],
                [
                    'id'=>7,
                    'section'=>'module',
                    'heading'=>'teacher',
                    'details'    => json_encode([
                        [
                            'id'=>1,
                            'need_permission'=>true,
                            'name'=>'teacher.index',
                            'heading'=>'Index',
                            'url'=>'admin/teacher',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>'teacher.index',
                            'name'=>'teacher.get_teacher',
                            'heading'=>'Index',
                            'url'=>'admin/teacher/get_teacher',
                        ],
                        [
                            'id'=>3,
                            'need_permission'=>false,
                            'name'=>'teacher.create',
                            'heading'=>'Create',
                            'url'=>'admin/teacher/create',
                        ],
                        [
                            'id'=>4,
                            'need_permission'=>true,
                            'name'=>'teacher.save',
                            'heading'=>'Save',
                            'url'=>'admin/teacher/save',
                        ],
                        [
                            'id'=>5,
                            'need_permission'=>false,
                            'name'=>'teacher.edit',
                            'heading'=>'Edit',
                            'url'=>'admin/teacher/edit/{id}',
                        ],
                        [
                            'id'=>6,
                            'need_permission'=>true,
                            'name'=>'teacher.update',
                            'heading'=>'Update',
                            'url'=>'admin/teacher/update/{id}',
                        ],
                        [
                            'id'=>7,
                            'need_permission'=>true,
                            'name'=>'teacher.delete',
                            'heading'=>'Delete',
                            'url'=>'admin/teacher/delete/{id}',
                        ],
                    ])

                    ],
                [
                    'id'=>8,
                    'section'=>'module',
                    'heading'=>'question',
                    'details'    => json_encode([
                        [
                            'id'=>1,
                            'need_permission'=>true,
                            'name'=>'question.index',
                            'heading'=>'Index',
                            'url'=>'admin/question',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>'question.index',
                            'name'=>'quiz.question_list',
                            'heading'=>'Index',
                            'url'=>'admin/question_list/{id}',
                        ],
                        [
                            'id'=>3,
                            'need_permission'=>false,
                            'name'=>'quiz.quiz_question_list_update',
                            'heading'=>'Index',
                            'url'=>'admin/quiz_question_list/update',
                        ],
                        [
                            'id'=>4,
                            'need_permission'=>false,
                            'name'=>'question.create',
                            'heading'=>'Create',
                            'url'=>'admin/question/create',
                        ],
                        [
                            'id'=>5,
                            'need_permission'=>true,
                            'name'=>'question.save',
                            'heading'=>'Save',
                            'url'=>'admin/question/save',
                        ],
                        [
                            'id'=>6,
                            'need_permission'=>false,
                            'name'=>'question.edit',
                            'heading'=>'Edit',
                            'url'=>'admin/question/edit/{id}',
                        ],
                        [
                            'id'=>7,
                            'need_permission'=>true,
                            'name'=>'question.update',
                            'heading'=>'Update',
                            'url'=>'admin/question/update/{id}',
                        ],
                        [
                            'id'=>8,
                            'need_permission'=>true,
                            'name'=>'question.delete',
                            'heading'=>'Delete',
                            'url'=>'admin/question/delete/{id}',
                        ],
                    ])

                    ],
                [
                    'id'=>9,
                    'section'=>'module',
                    'heading'=>'quiz',
                    'details'    => json_encode([
                        [
                            'id'=>1,
                            'need_permission'=>true,
                            'name'=>'quiz.index',
                            'heading'=>'Index',
                            'url'=>'admin/quiz',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>'quiz.index',
                            'name'=>'admin.get_quiz',
                            'heading'=>'Index',
                            'url'=>'admin/quiz/get_quiz',
                        ],
                        [
                            'id'=>3,
                            'need_permission'=>false,
                            'name'=>'quiz.create',
                            'heading'=>'Create',
                            'url'=>'admin/quiz/create',
                        ],
                        [
                            'id'=>4,
                            'need_permission'=>true,
                            'name'=>'quiz.save',
                            'heading'=>'Save',
                            'url'=>'admin/quiz/save',
                        ],
                        [
                            'id'=>5,
                            'need_permission'=>false,
                            'name'=>'quiz.edit',
                            'heading'=>'Edit',
                            'url'=>'admin/quiz/edit/{id}',
                        ],
                        [
                            'id'=>6,
                            'need_permission'=>true,
                            'name'=>'quiz.update',
                            'heading'=>'Update',
                            'url'=>'admin/quiz/update/{id}',
                        ],
                        [
                            'id'=>7,
                            'need_permission'=>true,
                            'name'=>'quiz.delete',
                            'heading'=>'Delete',
                            'url'=>'admin/quiz/delete/{id}',
                        ],
                    ])

                    ],
                [
                    'id'=>10,
                    'section'=>'module',
                    'heading'=>'group',
                    'details'    => json_encode([
                        [
                            'id'=>1,
                            'need_permission'=>true,
                            'name'=>'group.index',
                            'heading'=>'Index',
                            'url'=>'admin/group',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>'group.index',
                            'name'=>'group',
                            'heading'=>'Index',
                            'url'=>'admin/group/get_group',
                        ],
                        [
                            'id'=>3,
                            'need_permission'=>false,
                            'name'=>'group.create',
                            'heading'=>'Create',
                            'url'=>'admin/group/create',
                        ],
                        [
                            'id'=>4,
                            'need_permission'=>true,
                            'name'=>'group.save',
                            'heading'=>'Save',
                            'url'=>'admin/group/save',
                        ],
                        [
                            'id'=>5,
                            'need_permission'=>false,
                            'name'=>'group.edit',
                            'heading'=>'Edit',
                            'url'=>'admin/group/edit/{id}',
                        ],
                        [
                            'id'=>6,
                            'need_permission'=>true,
                            'name'=>'group.update',
                            'heading'=>'Update',
                            'url'=>'admin/group/update/{id}',
                        ],
                        [
                            'id'=>7,
                            'need_permission'=>true,
                            'name'=>'group.delete',
                            'heading'=>'Delete',
                            'url'=>'admin/group/delete/{id}',
                        ],
                        [
                            'id'=>8,
                            'need_permission'=>false,
                            'name'=>'parent.map',
                            'heading'=>'Map',
                            'url'=>'admin/group/map/lat_long',
                        ],
                    ])

                    ],
                [
                    'id'=>11,
                    'section'=>'module',
                    'heading'=>'student_plan',
                    'details'    => json_encode([
                        [
                            'id'=>1,
                            'need_permission'=>true,
                            'name'=>'student_plan.index',
                            'heading'=>'Index',
                            'url'=>'admin/student_plan',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>'student_plan.index',
                            'name'=>'get_student_plan.index',
                            'heading'=>'Index',
                            'url'=>'admin/student_plan/get_student_plan',
                        ],
                        [
                            'id'=>3,
                            'need_permission'=>false,
                            'name'=>'student_plan.create',
                            'heading'=>'Create',
                            'url'=>'admin/student_plan/create',
                        ],
                        [
                            'id'=>4,
                            'need_permission'=>true,
                            'name'=>'student_plan.save',
                            'heading'=>'Save',
                            'url'=>'admin/student_plan/save',
                        ],
                        [
                            'id'=>5,
                            'need_permission'=>false,
                            'name'=>'student_plan.edit',
                            'heading'=>'Edit',
                            'url'=>'admin/student_plan/edit/{id}',
                        ],
                        [
                            'id'=>6,
                            'need_permission'=>true,
                            'name'=>'student_plan.update',
                            'heading'=>'Update',
                            'url'=>'admin/student_plan/update/{id}',
                        ],
                        [
                            'id'=>7,
                            'need_permission'=>true,
                            'name'=>'student_plan.delete',
                            'heading'=>'Delete',
                            'url'=>'admin/student_plan/delete/{id}',
                        ],
                    ])

                    ],
                [
                    'id'=>12,
                    'section'=>'module',
                    'heading'=>'workshop',
                    'details'    => json_encode([
                        [
                            'id'=>1,
                            'need_permission'=>true,
                            'name'=>'workshop.index',
                            'heading'=>'Index',
                            'url'=>'admin/workshop',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>'workshop.index',
                            'name'=>'get_student_plan.index',
                            'heading'=>'Index',
                            'url'=>'admin/workshop/get_workshop',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>false,
                            'name'=>'workshop.create',
                            'heading'=>'Create',
                            'url'=>'admin/workshop/create',
                        ],
                        [
                            'id'=>3,
                            'need_permission'=>true,
                            'name'=>'workshop.save',
                            'heading'=>'Save',
                            'url'=>'admin/workshop/save',
                        ],
                        [
                            'id'=>4,
                            'need_permission'=>false,
                            'name'=>'workshop.edit',
                            'heading'=>'Edit',
                            'url'=>'admin/workshop/edit/{id}',
                        ],
                        [
                            'id'=>5,
                            'need_permission'=>true,
                            'name'=>'workshop.update',
                            'heading'=>'Update',
                            'url'=>'admin/workshop/update/{id}',
                        ],
                        [
                            'id'=>6,
                            'need_permission'=>true,
                            'name'=>'workshop.delete',
                            'heading'=>'Delete',
                            'url'=>'admin/workshop/delete/{id}',
                        ],
                    ])

                    ],
                [
                    'id'=>13,
                    'section'=>'module',
                    'heading'=>'role',
                    'details'    => json_encode([
                        [
                            'id'=>1,
                            'need_permission'=>true,
                            'name'=>'role.index',
                            'heading'=>'Index',
                            'url'=>'admin/role',
                        ],
                        [
                            'id'=>2,
                            'need_permission'=>false,
                            'name'=>'role.create',
                            'heading'=>'Create',
                            'url'=>'admin/role/create',
                        ],
                        [
                            'id'=>3,
                            'need_permission'=>true,
                            'name'=>'role.save',
                            'heading'=>'Save',
                            'url'=>'admin/role/save',
                        ],
                        [
                            'id'=>4,
                            'need_permission'=>false,
                            'name'=>'role.edit',
                            'heading'=>'Edit',
                            'url'=>'admin/role/edit/{id}',
                        ],
                        [
                            'id'=>5,
                            'need_permission'=>true,
                            'name'=>'role.update',
                            'heading'=>'Update',
                            'url'=>'admin/role/update/{id}',
                        ],
                        [
                            'id'=>6,
                            'need_permission'=>true,
                            'name'=>'role.delete',
                            'heading'=>'Delete',
                            'url'=>'admin/role/delete/{id}',
                        ],
                    ])

                    ],
    ];

    Admin_url::where('id','!=',0)->delete();
        foreach($admin_url_data as $aud){
            Admin_url::firstOrCreate(
                $aud
            );
        }

    }
}
