# jQuery Easing Plugin

What is it? A jQuery plugin from GSGD to give advanced easing options. More info [here](http://gsgd.co.uk/sandbox/jquery/easing)

For CDN please use CloudFlare [`http://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.3/jquery.easing.min.js`](http://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.3/jquery.easing.min.js) to help my host. Thank you.

## Popup?

If you're coming here because of a popup on your site I'm sorry, but the increased [hotlinking](https://simple.wikipedia.org/wiki/Hotlinking) has caused me issues with my hosting company so I'm taking steps to try and sort it out. Please upload the script to your own server and update any urls pointing to `gsgd.co.uk` to use that version of the file or you could try using the above url for CDN (though this currently only has the 1.3 easing script, look at http://cdnjs.com/ for more info and maybe try and add any missing files/versions still in use).

It's as simple as changing:

`<script type="text/javascript" src="http://gsgd.co.uk/sandbox/jquery/easing/jquery.easing.1.3.js"></script>`

to:

`<script type="text/javascript" src="http://cdnjs.cloudflare.com/ajax/libs/jquery-easing/1.3/jquery.easing.min.js"></script>`

or the same file uploaded to your server. This needs to be done for all html pages or templates that you're seeing the popup on.

Please also note, I have _no problem_ with _anyone's_ use of the plugin without my knowledge or permission, it's just the [hotlinking](http://altlab.com/hotlinking.html) that's causing me a headache. 

If you email me at hotlinking@gsgd.co.uk I'm happy to try and exclude your website while you sort this out though I can't guarantee how long it'll take me to get through all the requests. Please follow these two simple steps on how to format your email:

1) please use `remove` in the subject line

2) please have the domain(s) you want excluded on their own on separate lines without any `http`/`www` prefix (eg: `domain.com` not `http://www.domain.com`)

### Still none the wiser?

If you have no idea why your site is hotlinking my script it's likely because a theme or other plugin you're using on your website has included it for you. Your best bet is to ask the person who set up your website to help you remove it. You could also contact the plugin/theme author to ensure they update the plugin (especially if you paid for it).

If you're having trouble with your web design company, please be aware this isn't a big change for them, it shouldn't be something that takes longer than 10-15 minutes for them to change and, in my opinion, probably shouldn't be something they should charge you for. There are instructions and people offering paid help to remove the hotlink if you have lost contact with your site creator, searching via your favourite search engine will probably bring up one or two.

Many thanks    
George

Following are some specific removal instructions for various themes and plugins:

## WP ACCORDION SLIDER users:

Good walkthrough on how to remove from WP ACCORDION SLIDER http://serpastian.blogspot.co.uk/2013/04/please-stop-hotlinking-my-easing-script.html might help other wordpress users as well.

## Themeforest (Impulse/Vendor) theme users:

http://themeforest.net/item/impulse-clean-magazine-theme/discussion/1500221
http://themeforest.net/item/vendor-premium-wordpress-portfolio-theme/discussion/224169#comment_3812070

## Zen Cart users:

http://www.zen-cart.com/showthread.php?207719-quot-Please-stop-hotlinking-my-easing-script-quot-Warning&p=1199906#post1199906
